{{-- resources/views/admin/users/edit.blade.php --}}
@extends('layouts.admin')

@section('content')
<div class="users-management">
    <div class="users-header">
        <h1>Edit User: {{ $user->name }}</h1>
        <div class="users-actions">
            <a href="{{ route('admin.users.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Users
            </a>
        </div>
    </div>

    @if($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="row">
        <div class="col-md-4">
            <div class="dashboard-card mt-4">
                <div class="dashboard-card-header">
                    <h3>User Information</h3>
                </div>
                <div class="dashboard-card-body">
                    <form action="{{ route('admin.users.update', $user) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input type="text" id="name" name="name" value="{{ old('name', $user->name) }}" required>
                        </div>

                        <input type="hidden" id="steamid" name="steamid" value="{{ $user->steamid }}">
                        
                        <div class="form-group">
                            <label for="avatar">Avatar URL</label>
                            <input type="url" id="avatar" name="avatar" value="{{ old('avatar', $user->avatar) }}">
                        </div>
                        
                        <div class="form-group">
                            <label>Roles</label>
                            @foreach($roles as $role)
                                <div class="form-check">
                                    <input type="checkbox" id="role_{{ $role }}" name="roles[]" value="{{ $role }}" 
                                        {{ in_array($role, old('roles', $user->roles->pluck('name')->toArray())) ? 'checked' : '' }}>
                                    <label for="role_{{ $role }}">{{ $role }}</label>
                                </div>
                            @endforeach
                        </div>
                        
                        <div class="form-group text-right">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update User
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="dashboard-card mt-4">
                <div class="dashboard-card-header">
                    <h3>Profile Preview</h3>
                </div>
                <div class="dashboard-card-body text-center">
                    <img src="{{ $user->avatar }}" alt="{{ $user->name }}" style="width: 120px; height: 120px; border-radius: 50%; margin-bottom: 20px;">
                    <h3>{{ $user->name }}</h3>
                    <div>
                        @forelse($user->roles as $role)
                            <span class="user-role {{ strtolower($role->name) == 'admin' ? 'role-admin' : (strtolower($role->name) == 'moderator' ? 'role-moderator' : 'role-user') }}">
                                {{ $role->name }}
                            </span>
                        @empty
                            <span class="user-role role-user">User</span>
                        @endforelse
                    </div>
                    <div style="margin-top: 15px;">
                        <a href="{{ $user->getSteamProfileUrl() }}" target="_blank" class="btn btn-secondary">
                            <i class="fab fa-steam"></i> View Steam Profile
                        </a>
                    </div>
                </div>
            </div>
        </div>
            
        <div class="col-md-4">
            <div class="dashboard-card mt-4">
                <div class="dashboard-card-header">
                    <h3>User Statistics</h3>
                </div>
                <div class="dashboard-card-body">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Slug:</span>
                        <span>{{ $user->slug }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Last Active:</span>
                        <span>{{ $user->last_active_at ? $user->last_active_at->format('M d, Y H:i') : 'Never' }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Registered:</span>
                        <span>{{ $user->created_at->format('M d, Y') }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection